if exists ( select * from sys.procedures where name = 'p_consulta_produto_preco_liq' )
begin
	drop procedure p_consulta_produto_preco_liq
end
go


create proc p_consulta_produto_preco_liq
(	@desc_consulta  varchar( 200 )
	, @tp_consulta  int                 -- 1 = Produto nome   2 = Principio ativo   3 = Produto nome usual
	, @cd_emp  int     
	, @cd_filial  int  
	, @cd_conv  int   
	, @nr_cartao_fidel varchar( 50 )  
	, @ean  int     
	, @cd_cli  int          
	, @qtde_prod  int 
	, @application  int  
	, @id_promo int
	, @is_receita  int
	, @cd_frm_pgto  int
	, @cd_vend  int
	, @cd_parceiro  int
	, @tp_orig_venda  int
)

as

/*
exec p_consulta_produto_preco_liq 'CIMEGRIPE', 1 , 1 ,18, 0 , '0', 0, 0 , 1, 0, 0 ,0 ,1 ,0, 0,2
exec p_consulta_produto_preco_liq '%%%DOVE', 1 , 1 ,18, 0 , '0', 0, 0 , 1, 0, 0 ,0 ,1 ,0, 0,2
exec p_consulta_produto_preco_liq '%%DIPI', 2 , 1 ,18, 0 , '0', 0, 0 , 1, 0, 0 ,0 ,1 ,0, 0,2
*/

set nocount on

declare @var_cd_prod  int


declare @temp_cods_produto table 
         ( cd_prod int )
	
declare @temp_rs_produto_pool table
         (
		VERSAO VARCHAR(100)
		,CD_EMP INT
		,CD_FILIAL INT
		,CD_PROD INT
		,DS_PROD VARCHAR(100)
		,NM_FABRIC VARCHAR(100)
		,VLR_TABELA MONEY
		,VLR_OFERTA MONEY
		,QTDE_PONTO_FIDEL MONEY
		,CTR_PMC INT
		,LIB_DESC_VERBA INT
		,FLAG_REQUER_RECEIT INT
		,FLAG_ALTERAR_PRECO INT
		,PROD_USO_CONT INT
		,TP_PROD INT
		,VLR_CUSTO MONEY
		,CD_GRP INT
		,QTD_PONTO_VENDA MONEY
		,LMT_PROD_PONTO_VENDA MONEY
		,APRES_QT_VD INT
		,QTDE_ESTOQUE MONEY
		,DS_TIPO_RECEITA VARCHAR(100)
		,DS_COR_RECEITA VARCHAR(100)
		,PERC_DESC_LIMITE MONEY
		,CD_TRIB_FC VARCHAR(3)
		,PERC_ICMS_N_CONT_ESTA MONEY
		,PERC_RED_VD MONEY
		,LIBERA_VD_CONV INT
		,QTDE_PROD_MAX_CONV INT
		,FIXA_DESCONTO INT
		,TP_DESCONTO INT
		,VLR_ECONOMIA MONEY
		,DS_DESCONTO VARCHAR(150)
		,CD_TBL_DESC INT
		,TP_NIVEL INT
		,PERC_DESC MONEY
		,MAIOR_PERC_DESC MONEY
		,PRODUTO_CONTROLADO INT
		,VLR_PMC MONEY	
-- AVALIAR COLUNAS ABAIXO
		,FLAG_DESCONTO_TICKET_BLQ INT
		,PERC_DESC_FIDEL_MAX MONEY
		,PROMO_INDUSTRIA INT
		,PERC_DESC_ANIVER MONEY
		,PERC_DESC_CLAS MONEY
		,VLR_DESC_FABRIC MONEY
		,CAMPANHA INT
		,QTDE_PROD_CAMPANHA INT
		,FLAG_BLOQUEIA_DESCONTO INT
		,PERC_DESC_POS_PBM DECIMAL(6, 4)
		,CD_FAMILIA INT
		,NCM_PROD VARCHAR(50)
		,NR_REG_MS VARCHAR(150)
		,TP_TBL_DESC  INT DEFAULT ( 3 )
		)



INSERT INTO @temp_cods_produto
--declare 	@desc_consulta  varchar( 200 ) = 'CIMEGRIPE'	, @tp_consulta  int = 1 , @cd_emp int = 1 	, @cd_filial  int    = 18
SELECT TOP 300 
		P.CD_PROD 
--, C.TP_PROD , PEND.*
	FROM EST_PROD  P
	JOIN EST_PROD_CPL  C
		ON C.CD_EMP  = P.CD_EMP
		AND C.CD_FILIAL = @cd_filial
		AND C.CD_PROD = P.CD_PROD
	JOIN EST_PROD_PRECO  PR
		ON PR.CD_EMP = C.CD_EMP
		AND PR.CD_FILIAL = C.CD_FILIAL
		AND PR.CD_PROD = C.CD_PROD
   LEFT JOIN EST_PROD_PRINC_ATIVOS_EST_PROD ppa 
      ON ppa.CD_EMP = P.CD_EMP 
      and ppa.CD_PROD = P.CD_PROD 
   LEFT JOIN EST_PROD_PRINC_ATIVOS pa 
      ON pa.CD_PRINC_ATIVOS = ppa.CD_PRINC_ATIVOS
	JOIN V_EST_PROD_CPL_PENDENCIAS PEND ON C.CD_EMP = PEND.CD_EMP
														AND C.CD_FILIAL = PEND.CD_FILIAL
														AND C.CD_PROD = PEND.CD_PROD
   WHERE P.CD_EMP = 1
		AND C.CD_FILIAL = @cd_filial
      AND P.STS_PROD IN ( 0 , 2 )
		AND PEND.STS_PROD_FILIAL IN ( 0 , 2 )   ---- ver aqui
      AND C.TP_PROD IN (0,9,10,11)
		AND P.STS_PROD_CALL_CENTER = 0
		AND PR.VLR_TABELA > 0
      AND P.CD_FILIAL >= 0
      AND ( ( @tp_consulta = 1 and UPPER(P.DS_PROD) LIKE CONCAT( @desc_consulta , '%' ) )
         OR ( @tp_consulta = 2 and UPPER(COALESCE(pa.DS_PRINC_ATIVOS,'')) LIKE CONCAT( @desc_consulta , '%' ) ) 
         OR ( @tp_consulta = 3 and UPPER(P.DS_USUAL) LIKE CONCAT( @desc_consulta , '%' ) ) 
         )

-----------------PROCESSAMENTO DA PROCEDURE------------------------------------------------

while exists (  select top 1 1 from @temp_cods_produto order by cd_prod )  
begin

   set @var_cd_prod = (select top 1 cd_prod from @temp_cods_produto order by cd_prod )

   insert into @temp_rs_produto_pool
   EXEC P_EST_PROD_DESCONTOS
         @CD_EMP  = @cd_emp
         , @CD_FILIAL  = @cd_filial
         , @CD_PROD   = @var_cd_prod
         , @CD_CONV   = @cd_conv
         , @NR_CARTAO_FIDEL = @nr_cartao_fidel
         , @EAN    = @ean
         , @CD_CLI  = @cd_cli
         , @QTDE_PROD    = @qtde_prod
         , @APPLICATION  = @application
         , @ID_PROMO    = @id_promo
         , @IS_RECEITA  =  @is_receita
         , @CD_FRM_PGTO  = @cd_frm_pgto
         , @IGNORED   = 0
         , @CD_VEND   = @cd_vend
         , @CD_PARCEIRO  = @cd_parceiro
         , @TP_ORIG_VENDA  = @tp_orig_venda

   delete from @temp_cods_produto
      where cd_prod = @var_cd_prod

end
		
SELECT DISTINCT --TOP 300    --- filtrado tip nos codigos para calculo do liquido
		EST_PROD.CD_PROD as 'Código',  EST_PROD.DS_PROD  as 'Produto',  
		Convert(Decimal(12,2),EST_PROD_PRECO.VLR_OFERTA) as 'Oferta',  
		Convert(Decimal(12,2),EST_PROD_PRECO.VLR_TABELA) as 'Venda', 
		CONVERT( DECIMAL( 12 ,2 ) , COALESCE(EST_PROD_PRECO.VLR_TABELA,0.00)
									- (COALESCE(EST_PROD_PRECO.VLR_TABELA,0.00)*(t.PERC_DESC/100.00) ) ) as 'Liquido', 
		Convert(Decimal(12,2),
		CASE COALESCE((SELECT COALESCE(CAST(VALOR AS INT), 0) FROM PRC_EMP_CONFIG WHERE CD_EMP = 1 AND CD_CHAVE LIKE 'CTR_CUSTO_SEMAFORO'), 0) 
			WHEN 0 
				THEN EST_PROD_CPL.VLR_CUSTO 
				ELSE EST_PROD_CPL.VLR_CUSTO_MD 
			END) 'Custo', 
		(SELECT CAST(COALESCE(SUM(QT_EST), 0)AS INT) 
			FROM EST_PROD_CPL      
			WHERE CD_EMP = 1 
				AND CD_PROD = EST_PROD.CD_PROD  
				AND QT_EST > 0 
				AND CD_FILIAL IN 
						(SELECT CD_FILIAL 
							FROM TELE_PRC_FILIAL A 
							WHERE  CD_EMP = 1 
							AND A.FILIAL_POLO = 1 )) 'Est. Polos',  
		SUBSTRING(EST_PROD_FABRIC.NM_FABRIC,1,20) 'Fabricante',  
		CASE ISNULL(EST_PROD_FARMACIA_POPULAR.CD_PROD,0) WHEN 0 THEN '' ELSE 'F.POP' END 'F.Pop',  
		DS_ARV_MERC_LINHA 'Linha',  
		DS_PRINC_ATIVOS 'Princ.Ativo',  
		CASE WHEN ISNULL(EST_PROD_CPL.FLAG_VERBA_DESCON,0) > 0 THEN EST_PROD_CPL.FLAG_VERBA_DESCON ELSE EST_PROD.FLAG_VERBA_DESCON END  'Desc.Verba',  
		CASE 
			WHEN ISNULL(FLAG_PRODUTO_CONTROLADO, 0) > 0 THEN 
					ISNULL((SELECT ISNULL(VALOR, 0) FROM PRC_EMP_CONFIG WHERE CD_EMP = 1 AND  CD_CHAVE = 'BLOQUEIA_VD_CONTROLADO_TELEVENDAS'),0) 
				ELSE 0 
			END AS 'Bloqueado' 
      --, CAST( COALESCE(est_grp_comis_pdv.ds_grp ,'NAO INFORMADO') as varchar(100) ) as grupo_comissao
   FROM @temp_rs_produto_pool  t
   INNER JOIN EST_PROD_CPL  
      ON EST_PROD_CPL.CD_EMP = t.CD_EMP 
      AND EST_PROD_CPL.CD_FILIAL = t.CD_FILIAL 
      AND EST_PROD_CPL.CD_PROD = t.CD_PROD
   INNER JOIN EST_PROD_PRECO 
      ON EST_PROD_CPL.CD_EMP = EST_PROD_PRECO.CD_EMP 
      AND EST_PROD_CPL.CD_FILIAL = EST_PROD_PRECO.CD_FILIAL 
      AND EST_PROD_CPL.CD_PROD = EST_PROD_PRECO.CD_PROD 
   INNER JOIN EST_PROD 
      ON EST_PROD_CPL.CD_EMP = EST_PROD.CD_EMP 
      AND EST_PROD_CPL.CD_PROD = EST_PROD.CD_PROD 
   LEFT JOIN EST_PROD_FABRIC 
      ON EST_PROD.CD_FABRIC = EST_PROD_FABRIC.CD_FABRIC 
   LEFT JOIN est_prod_prt 
      ON est_prod_prt.cd_prt = est_prod_cpl.prat 
   LEFT JOIN EST_PROD_CPL_CAMP_BRINDE 
      ON EST_PROD_CPL_CAMP_BRINDE.CD_PROD = EST_PROD.CD_PROD 
   LEFT JOIN est_prod_princ_ativos_est_prod 
      ON est_prod_cpl.cd_prod = est_prod_princ_ativos_est_prod.cd_prod 
   LEFT JOIN est_prod_princ_ativos 
      ON est_prod_princ_ativos_est_prod.cd_princ_ativos = est_prod_princ_ativos.cd_princ_ativos 
   --left join est_grp_comis_pdv_cpl 
   --   on est_prod_cpl.cd_emp = est_grp_comis_pdv_cpl.cd_emp 
   --   and est_prod_cpl.cd_filial = est_grp_comis_pdv_cpl.cd_filial 
   --   and est_prod_cpl.cd_prod = est_grp_comis_pdv_cpl.cd_prod 
   --left join est_grp_comis_pdv 
   --   on est_grp_comis_pdv_cpl.cd_emp = est_grp_comis_pdv.cd_emp 
   --   and est_grp_comis_pdv_cpl.cd_grp = est_grp_comis_pdv.cd_grp 
	LEFT JOIN EST_PROD_EST_ARV_MERCADOLOGICA 
		ON EST_PROD_EST_ARV_MERCADOLOGICA.CD_EMP = EST_PROD.CD_EMP 
		AND EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD = EST_PROD.CD_PROD  
	LEFT JOIN EST_PROD_FARMACIA_POPULAR 
		ON EST_PROD_FARMACIA_POPULAR.CD_EMP = EST_PROD_CPL.CD_EMP
		AND EST_PROD_FARMACIA_POPULAR.CD_FILIAL = EST_PROD_CPL.CD_FILIAL  
		AND EST_PROD_FARMACIA_POPULAR.CD_PROD = EST_PROD_CPL.CD_PROD  
	LEFT JOIN EST_ARV_MERC_LINHA 
		ON EST_PROD_EST_ARV_MERCADOLOGICA.CD_ARV_MERC_LINHA = EST_ARV_MERC_LINHA.CD_ARV_MERC_LINHA  
   WHERE EST_PROD.STS_PROD <> 1  
      AND (EST_PROD.FLAG_VD_CALL_CENTER = 0 OR EST_PROD.FLAG_VD_CALL_CENTER IS NULL) 
      AND EST_PROD_CPL.TP_PROD IN (0,9,10,11)  
      AND EST_PROD_CPL_CAMP_BRINDE.CD_PROD IS NULL
   ORDER BY EST_PROD.DS_PROD

go

